#include <SFML/Graphics.hpp>
#include <ZLE.hpp>

int main()
{
    sf::RenderWindow window(sf::VideoMode({400, 400}), "Tilemap example");
    window.setFramerateLimit(60);
    
    sf::Texture tiles;
    tiles.loadFromFile("tiles.png");

    zle::TileMap tmap(tiles);
    tmap.loadFromFile("map.tmap");
    tmap.setTextureGap(sf::Vector2u(2, 0));
    tmap.setTextureTileSize({100, 100});
    tmap.setTileSize({50, 50});

    while (window.isOpen())
    {
        while (auto event = window.pollEvent())
        {
            if (event->is<sf::Event::Closed>())
                window.close();
        }

        window.clear();
        window.draw(tmap);
        window.display();
    }

    return 0;
}